#include <Arduino.h>
#include <SoftwareSerial.h>
#include <SPI.h>

#define rxPin 8 //PB0
#define txPin 9 //PB1
SoftwareSerial mySerial =  SoftwareSerial(rxPin, txPin);


void setup() {
  //PORTD for counter
  //PORTD  = Software Pin 0-7 
  byte i;
  for(i=0; i<8; i++){
          pinMode(i, OUTPUT);
  }
  PORTD = 0;

  //Software Serial
  pinMode(rxPin, INPUT);
  pinMode(txPin, OUTPUT);
  mySerial.begin(230400);

  //SPI
  pinMode(10, OUTPUT); // Chip Select
  SPI.begin();
  SPI.setClockDivider(SPI_CLOCK_DIV128);
  digitalWrite(10, HIGH);
}

void loop() {
  byte counter = 0;
  char buffer[16];
      

  while (1){
    _delay_us(500);

    //8 bit Counter
    PORTD = counter;
    
    //UART
    mySerial.write("counter:");
    sprintf(buffer, "%d", counter);
    mySerial.write(buffer);
    mySerial.write('\n');
    
    //SPI
    digitalWrite(10, LOW);
    SPI.transfer(counter);
    digitalWrite(10, HIGH);

    counter++;
  }
}